%% FWM Bragg scattering phasematching calculation with empirical dispersion
% PJM 2019

% 775 and 670 pumps
% Fixed target at 1550, variable target around 1092

% Ultrabroad phase matching!

% This version is modified to make nice plots for slides

clear

tic

% Dispersion parameters

% Nice GVS
pitch = 2.35;
fill = 0.5;

% Charlotte
%pitch = 1.75;
%fill = 0.444;
%fill = 0.44;

% No GVS
%pitch = 3.05;
%fill = 0.58;

ldamin = 0.6;
ldamax = 1.8;

points = 5000;

% Phasematching parameters

pmpoints = 1064;				% No of points in phasematching calculation

lambdapmin = 0.6;			% Min pump wavelength in phasematching loop plots
lambdapmax = 1.1;			% Max pump wavelength in phasematching loop plots

lambdasmin = 0.8			% Range for s,i detunings in phasematching loop plots
lambdasmax = 1.4;

lngth = 5e4;				% Fibre length in um

gamma1 = 0e-3;				% Nonlinear coefficients (per micron per Watt)
gamma2 = 0e-3;
p1 = 300e-3;				% Pump powers (Watts)
p2 = 100e-3;

lambda0p1 = 0.64;
%lambda0p1 = 0.633;          % Central wavelength of fixed pump
lambda0p2 = 0.826;
lambda0s = 1;             % Central wavelength of tunable pump
lambda0t = f2w(abs(w2f(lambda0p1)-w2f(lambda0p2)-w2f(lambda0s)))%1.55;            % Target photon wavelength (fixed)
         % Desired source wavelengt

fwhmp1lambda = 0.001;

%% Empirical PCF dispersion calculation from Saitoh and Koshiba, Opt Exp 13, 267 (2005)

if fill>1 
	disp('Error! Filling fraction > 1');
elseif 1>=fill && fill>0.8
	disp('Warning: Filling fraction too large');
elseif 0.2>fill && fill>=0
	disp('Warning: Filling fraction too small');
elseif fill<0
	disp('Error! Negative filling fraction');
end

lambda = linspace(ldamin,ldamax,points);

% Sellmeier equation for silica

n = @(lda) sqrt(1 + (0.6961663*lda.^2)./(lda.^2-0.004679148)...
	+ (0.4079426*lda.^2)./(lda.^2-0.01351206)...
	+ (0.8974794*lda.^2)./(lda.^2-97.93400));

% Coefficients in empirical calculation for V and W

a = [0.54808 0.71041 0.16904 -1.52736;
	5.00401 9.73491 1.85765 1.06745;
	-10.43248 47.41496 18.96849 1.93229;
	8.22992 -437.50962 -42.4318 3.89];

b = [5 1.8 1.7 -0.84;
	7 7.32 10 1.02;
	9 22.8 14 13.4];

c = [-0.0973 0.53193 0.24876 5.29801;
	-16.70566 6.70858 2.72423 0.05142;
	67.13845 52.04855 13.28649 -5.18302;
	-50.25518 -540.66947 -36.80372 2.7641];

d = [7 1.49 3.85 -2;
	9 6.58 10 0.41;
	10 24.8 15 6];

% Calculation of V, W, and neff

ai = a(1,:) + sum(a(2:end,:).*fill.^b,1);
v = ai(1) + ai(2)./(1+ai(3).*exp(ai(4).*lambda./pitch));

ci = c(1,:) + sum(c(2:end,:).*fill.^d,1);
w = ci(1) + ci(2)./(1+ci(3).*exp(ci(4).*lambda./pitch));


neff = sqrt(n(lambda).^2 + (3/(2*pi*pitch)^2).*(lambda.^2).*(w.^2-v.^2));

% Group velocity index

lambda1 = zeros(1,length(lambda)-1);
neff1 = zeros(1,length(lambda)-1);

for n=1:length(lambda)-1
	lambda1(1,n) = (lambda(1,n)+lambda(1,n+1))/2;					% New lambda vector with one fewer entry
	neff1(1,n) = (neff(1,n)+neff(1,n+1))/2;							% New neff vector with one fewer entry
end

dneff1 = diff(neff)./diff(lambda);									% dneff/dlambda
ng = neff1 - lambda1.*dneff1;

[zdng,zdi] = min(ng);
zdl = (lambda(:,zdi)+lambda(:,zdi+1))/2;							% Zero GVD wavelength

disp('Zero dispersion wavelength = ');
disp(zdl);

c = 3e14;															% Re-define c to be speed of light in um/s

vg = c./ng;															% vg in um/s
beta1 = ng./c;														% beta1 in s/um

% Dispersion parameter

lambda2 = zeros(1,length(lambda)-2);

for n=1:length(lambda)-2
	lambda2(1,n) = (lambda(1,n)+lambda(1,n+1))/2;					% New lambda vector with two fewer entries
end

dneff2 = diff(dneff1)./diff(lambda1);								% d2neff/dlambda2
beta2 = 1e33*((lambda2.^3)./(2*pi*c^2)).*dneff2;					% beta2 in (ps^2)/km
dp = -1e18*(lambda2./c).*dneff2;									% Dispersion parameter in ps/nm/km

%% Phasematching calculation

% Fibre indexes as functions of lambda

nfast = @(lda) spline(lambda,neff,lda);
%nslow = @(lda) spline(lambda,neff,lda) - dn;

% k-vectors as functions of omega
kp1 = @(omp1) nfast(2*pi*c./omp1).*omp1/c;
kp2 = @(omp2) nfast(2*pi*c./omp2).*omp2/c;
ks = @(oms) nfast(2*pi*c./oms).*oms/c;
kt = @(omt) nfast(2*pi*c./omt).*omt/c;

dk = @(omp1,omp2,oms,omt) kp1(omp1) + kt(omt) - kp2(omp2) - ks(oms) + gamma1*(p1-p2);

% Phasematching contours as functions of lambdap and lambdas

% Switch variation of p1 and p2 to flip plot round
% Pump 2 frequency - varies along x-axis
lambdap2 = linspace(lambdapmin,lambdapmax,pmpoints);
omegap2 = ones(pmpoints,1)*(2*pi*c./lambdap2);

% Source frequency - varies along y-axis
lambdas = linspace(lambdasmin,lambdasmax,pmpoints);
omegas = (2*pi*c./lambdas)'*ones(1,pmpoints);

% Target frequency - fixed
omegat = ones(pmpoints,pmpoints)*(2*pi*c/lambda0t);

% Pump 1 frequency - varies in x and y
omegap1 = omegap2 + omegas - omegat;										% Energy conservation

% deltak calculation
deltakloop = dk(omegap1,omegap2,omegas,omegat);

% Axes tick labels for phasematching contour plot
posxloop = round(linspace(1,pmpoints,5));								% Must be integers
labxloop = round(100*2*pi*c./(omegap2(1,posxloop)))./100;					% round to 2 d.p.

labyloop = linspace(lambdasmin,lambdasmax,5);
posyloop = round(linspace(1,pmpoints,5));

% Phase matching function
pma = sin(0.5*deltakloop*lngth)./(0.5*deltakloop*lngth);
pmphi = exp(0.5*1i*deltakloop*lngth);
pmf = pmphi.* pma;

% Pump 1 function
omega0p1 = 2*pi*c/lambda0p1;
fwhmp1omega = (2*pi*c*fwhmp1lambda)/(lambda0p1)^2;
sigmap1omega = fwhmp1omega/((2*log(2))^0.5);

p1f = exp(-((omegap1 - omega0p1)./sigmap1omega).^2);

% Phase matching and pump 1 overlap; calculation of max overlap as function
% of p2 and source
pmfp1f = pmf.*p1f;
pmfp1fmaxp2 = max(abs(pmfp1f).^2);
pmfp1fmaxs = max(abs(pmfp1f).^2,[],2);

%% Group velocities

format long
ngp1 = ng(find(lambda>lambda0p1,1))
ngp2 = ng(find(lambda>lambda0p2,1))
ngs = ng(find(lambda>lambda0s,1))
ngt = ng(find(lambda>lambda0t,1))

ngp1/ngt
ngp2/ngs

toc
%% Plotting functions

% Plot parameters

fs = 18;
lw = 2.0;

xdim = 0.8;
ydim = 0.74;

x1 = 0.12;
x2 = 0.56;

y1 = 0.16;
y2 = 0.56;


% figure(1);
% clf
% set(gcf,'position',[100 100 600 400]);
% 
% subplot('position',[x1 y1 xdim ydim]);
% hold on
% imagesc(abs(pmf).^2);
% %imagesc(abs(p1f).^2);
% %contour(omegas-(2*pi*c/zdl),[0 0],'k','linewidth',2);
% contour(omegap1-(2*pi*c/lambda0p1),[0 0],'r--','linewidth',2);
% %contour(omegap2-(2*pi*c/lambda0p2),[0 0],'c','linewidth',2);
% % contour(omegap2-(2*pi*c/0.8),[0 0],'c','linewidth',2);
% % contour(omegap2-(2*pi*c/0.75),[0 0],'c','linewidth',2);
% %contour(omegas-(2*pi*c/lambda0s),[0 0],'g','linewidth',2);
% % contour(omegas-(2*pi*c/1.2),[0 0],'g','linewidth',2);
% % contour(omegas-(2*pi*c/1.25),[0 0],'g','linewidth',2);
% axis([1 pmpoints 1 pmpoints]);
% set(gca, 'XTick', posxloop);
% set(gca, 'XTickLabel', labxloop);
% set(gca, 'YDir', 'normal');
% set(gca, 'YTick', posyloop);
% set(gca, 'YTickLabel', labyloop);
% grid off
% set(gca, 'FontName', 'Helvetica');
% set(gca, 'FontSize', fs);
% xlabel('Pump 2 wavelength (\mum)');
% ylabel('Source wavelength (\mum)');

figure(4);
hold on
clf
set(gcf,'position',[500 100 600 400]);

subplot('position',[x1 y1 xdim ydim]);
plot(lambdas,pmfp1fmaxs,'linewidth',lw)
axis([lambdasmin 1.4 0 1.1]);
set(gca, 'FontName', 'Helvetica');
set(gca, 'FontSize', fs);
xlabel('Source wavelength (\mum)');
ylabel('Conversion efficiency limit');

